      PROGRAM XMATCH
C
C  Last update: 191006 RdG
C
C  Calculates the match between powder diffraction patterns.
C  Returns a value between 0.0 and 1.0 for the similarity (SI).
C  1.0 means perfect agreement, 0.0 means completely different.
C
C  NP: number of powder patterns
C  NX: number of data points 
C  XS: step size in 2theta                 
C  WI: single precision value for the width of the weighting function
C  SI: a single double precision value for the similarity 
C  CO: intensity values for each pattern
C  CM: similarity matrix
C
      DOUBLEPRECISION SI
      DIMENSION CO(3001,20),CM(20,20)
      NP=20
      NX=3001
      XS=0.02
      WI=0.62
      OPEN (UNIT=2, FILE='wcc.out', STATUS='UNKNOWN')
      CALL READPR(CO,NP,NX)
      DO 1 I=1,NP
        DO 2 J=I,NP
          CALL MATCH(CO(1,I),CO(1,J),NX,XS,WI,SI)
          CM(I,J)=SI
          CM(J,I)=SI
    2   CONTINUE
    1 CONTINUE
      WRITE(2,4) WI
      WRITE(2,5) (I,I=1,NP)
      DO 3 I=1,NP
        WRITE(2,6) I, (CM(I,J),J=1,NP)
    3 CONTINUE
    4 FORMAT(' Width of the weighting function = ',F5.2)
    5 FORMAT(7X,1X,20(I5,1X))
    6 FORMAT(I7,1X,20(F5.2,1X))
      STOP
      END
C
      SUBROUTINE READPR(CO,NP,NX)
      DIMENSION CO(3001,20)
      CHARACTER*12 FN(20)
      DATA FN /'cefraa.dat','cefrab.dat','cefrna.dat','cefraq.dat',
     1         'cf2acn.dat','cfbipi.dat','ceflx2.dat','ceflan.dat',
     2         'cecloa.dat','second.dat','cfrob3.dat','copabe.dat',
     3         'codi26.dat','codi27.dat','cfpabe.dat','cef2ff.dat',
     4         'cfhchn.dat','cf4maf.dat','cfdmfs.dat','cfm3hb.dat'/
      WRITE(2,*)'******************************************************'
      WRITE(2,*)'Test : 20 powder patterns of cephalosporin complexes .'
      WRITE(2,*)'See: J. Comp. Chem. (2001), 22, 3, 273-289.'
      WRITE(2,*)'Results must agree with data in Table IIId, page 285.'
      WRITE(2,*)'******************************************************'
      DO 1 I=1,NP
        OPEN (UNIT=1, FILE=FN(I), STATUS='OLD')
        DO 2 J=1,NX 
          READ(1,*,END=3) X,CO(J,I)  
    2   CONTINUE
    3   CLOSE (1)
        WRITE(2,4) I,FN(I)
    1 CONTINUE
    4 FORMAT(' Pattern ',I2,': ',A12,' read')
      WRITE(2,*)'******************************************************'
      RETURN
      END
C
      SUBROUTINE MATCH(C1,C2,NX,XS,WI,SI)
      DOUBLEPRECISION SI,A1,A2,CC
      INTEGER NX
      DIMENSION C1(NX),C2(NX)
      NW=NINT(WI/XS)
      RW=1./FLOAT(NW)
      CALL CORREL(C1,C1,NX,NW,RW,A1)
      CALL CORREL(C2,C2,NX,NW,RW,A2)
      CALL CORREL(C1,C2,NX,NW,RW,CC)
      SI=CC/SQRT(A1*A2)
      RETURN
      END
C
      SUBROUTINE CORREL(C1,C2,NX,NW,RW,CC)
      DIMENSION C1(NX),C2(NX)
      DOUBLEPRECISION T,CC
      CC=0.0
      DO 1 N=-NW+1,NW-1
        T=0.0               
        DO 2 I=1,NX
          J=I+N
          IF(J.LT.1.OR.J.GT.NX) GOTO 2
          T=T+C1(I)*C2(J)
    2   CONTINUE  
      CC=CC+T*(1.-RW*ABS(N))    
    1 CONTINUE
      RETURN
      END
